=begin
#---------------------------------------------------------------------------------------------------------
#*********************************************************************************************************
# Copyright © 2015 Fredo6 - Designed and written August 2011 by Fredo6
#
# Permission to use this software for any purpose and without fee is hereby granted
# Distribution of this software for commercial purpose is subject to:
#  - the expressed, written consent of the author
#  - the inclusion of the present copyright notice in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Description	:  Generic top loader for LibFredo6-compliant scripts.
#
# This file does checking on the environment for correct installation of LibFredo6 and the script itself
# The file is identical for all my plugins relying on LibFredo6
#*********************************************************************************************************
#---------------------------------------------------------------------------------------------------------
=end

require 'sketchup.rb'
require 'extensions.rb'

module Fredo6

if defined?(LibFredo6.top_load)
	hsh_ext, plugin, ext = LibFredo6.top_load(__FILE__, true)
	if hsh_ext && plugin && !ext
		ext = SketchupExtension.new hsh_ext[:name], hsh_ext[:floader]
		ext.creator = hsh_ext[:creator] 
		ext.description = hsh_ext[:description] 
		ext.version = hsh_ext[:version] 
		ext.copyright = hsh_ext[:copyright] 	
		status = Sketchup.register_extension ext, true
		plugin.load_finalize ext
	end	
else	
	UI.messagebox "You must install LibFredo6 version 6.9 or higher to run #{File.basename(__FILE__, ".rb")}"
end

end	#module Fredo6
